# 속도 업그레이드
실행 속도가 두 배가 되었어요. 문제는 이제 드론이 풀이 자라는 속도보다 더 빨리 수확해서 아무것도 수확하지 못하게 된다는 점이에요. 이 문제를 해결하기 위해 [if](docs/scripting/if.md) 분기와 [can_harvest](functions/can_harvest) 함수가 이제 해금되었어요.

## 수확하기 전에 확인하기
지금까지는 `True`와 `False`만 조건으로 사용했는데, 이건 `if`문과 함께 쓰기에는 그다지 유용하지 않아요. 

새로운 함수 `can_harvest()`는 더 나은 조건을 제공해요. `can_harvest()`는 드론 아래의 식물을 수확할 수 있으면 `True`를, 그렇지 않으면 `False`를 반환해요.

`if can_harvest():
	#do something`

이 함수를 이처럼 조건으로 사용할 수 있는 이유는 불리언 값을 반환하기 때문이에요.

반환 값은 기본적으로 기능이 실행된 후, 함수 호출 표현식이 반환된 값으로 평가된다는 것을 의미해요.

위 코드가 실행될 때 일어나는 일:
	-if문이 실행돼요
	-`can_harvest()`가 호출돼요
	-`can_harvest()`가 동작해요
	-`can_harvest()`가 `True` 또는 `False`를 반환해요
	-이제 문장은 `if True:` 또는 `if False:`가 돼요
	-수확할 수 있을 때만 코드 블록이 실행돼요

이제 `if`를 사용해서 드론이 너무 일찍 수확하는 것을 막을 수 있어요.